/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.common.diagnostics.AsmError;
import kickass.nonasm.util.functions.Func3;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class AssertErrorTailParser
implements ITailParser<AsmNode> {
    private IDirectiveParser<AsmNode> subParser;
    private Func3<ExprNode, ExprNode, SourceRange, AsmNode> exprAssertNodeCreator;
    private Func3<ExprNode, AsmNode, SourceRange, AsmNode> codeAssertNodeCreator;

    public AssertErrorTailParser(IDirectiveParser<AsmNode> iDirectiveParser, Func3<ExprNode, ExprNode, SourceRange, AsmNode> func3, Func3<ExprNode, AsmNode, SourceRange, AsmNode> func32) {
        this.subParser = iDirectiveParser;
        this.exprAssertNodeCreator = func3;
        this.codeAssertNodeCreator = func32;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        boolean bl;
        TokenStreamList tokenStreamList = iTokenStream.getUntilCommaSkipWsAndNl();
        if (tokenStreamList.getTerminatingToken().isEos()) {
            evaluationState.diagnosticMgr.add(new AsmError("Missing second argument", iToken.getSourceRange()));
            return null;
        }
        ExprNode exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        if (exprNode == null) {
            return null;
        }
        iTokenStream.skipWsAndNl();
        IToken iToken2 = iTokenStream.peek();
        boolean bl2 = bl = iToken2.getType() == TokenType.CurlyBracketRange;
        if (bl) {
            AsmNode asmNode = this.subParser.parse(iTokenStream, evaluationState);
            if (asmNode == null) {
                return null;
            }
            return this.codeAssertNodeCreator.apply(exprNode, asmNode, sourceRange);
        }
        ExprNode exprNode2 = ExprParser.parse(iTokenStream.getUntilSemiOrNlSkipWs(), evaluationState);
        if (exprNode2 == null) {
            return null;
        }
        return this.exprAssertNodeCreator.apply(exprNode, exprNode2, sourceRange);
    }
}

